/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.store;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.PeekingIterator;
import cz.insophy.inplan.shop.Material;
import cz.insophy.inplan.store.MaterialQuotas;
import cz.insophy.inplan.store.StoreActivity;
import cz.insophy.inplan.store.StoreSchedule;
import cz.insophy.inplan.superplan.GeneralizedRequest;
import cz.insophy.inplan.util.Comparators;
import cz.insophy.inplan.util.Tuple;
import java.util.Collection;
import java.util.Deque;
import java.util.Map;

class ForwardMaterialQuotas
extends MaterialQuotas {
    private final Map<Material, ForwardQuota> quotas = Maps.newIdentityHashMap();

    protected ForwardMaterialQuotas(Collection<Material> materials, long time, long matHorizonBase, StoreSchedule.MatHorizonTreatment matHorizonTreatment, StoreSchedule storeSchedule, Predicate<StoreActivity> saPredicate) {
        super(time, storeSchedule, matHorizonBase, matHorizonTreatment);
        for (Material material : materials) {
            long absMatHorizon = this.getAbsoluteMatHorizon(material, matHorizonBase, matHorizonTreatment);
            boolean horizonValid = GeneralizedRequest.isDateValid(absMatHorizon);
            ForwardQuota quo = new ForwardQuota();
            quo.throttles = Lists.newLinkedList();
            if (horizonValid && absMatHorizon <= time) {
                quo.throttles.add(Tuple.create(time, Double.POSITIVE_INFINITY));
            } else {
                double q = 0.0;
                double minQ = 0.0;
                if (horizonValid) {
                    quo.throttles.add(new Tuple<Long, Double>(absMatHorizon, 0.0));
                } else {
                    quo.throttles.add(new Tuple<Long, Double>(Long.MAX_VALUE, 0.0));
                }
                PeekingIterator<StoreActivity> iter = Iterators.peekingIterator(Lists.reverse(storeSchedule.getActivities(material)).iterator());
                while (iter.hasNext()) {
                    StoreActivity sa = iter.next();
                    if (!saPredicate.apply(sa) || horizonValid && sa.getTime() >= absMatHorizon) continue;
                    q -= sa.getQty();
                    if (iter.hasNext() && iter.peek().getTime() == sa.getTime() || !(q < minQ) || sa.getTime() <= time) continue;
                    quo.throttles.addFirst(new Tuple<Long, Double>(sa.getTime(), q));
                    minQ = q;
                }
                quo.delta = -q;
                if (horizonValid) {
                    quo.throttles.add(Tuple.create(absMatHorizon + 1L, Double.POSITIVE_INFINITY));
                }
            }
            this.quotas.put(material, quo);
        }
    }

    @Override
    protected void changeQuota(MaterialQuotas.MaterialQuota quota, double delta) {
        ForwardQuota mq = (ForwardQuota)quota;
        mq.delta += delta;
        if (delta < 0.0 && mq.getQuota() < -1.0E-7) {
            throw new IllegalArgumentException("Quota cannot be brought below zero by a manual change. Too small delta requested. delta=" + delta + " quota=" + mq.getQuota());
        }
    }

    @Override
    public void setTime(long time) {
        if (time < this.lastTime) {
            throw new IllegalArgumentException("Successive calls to setTime must be done with non-decreasing times.");
        }
        this.lastTime = time;
        for (ForwardQuota quota : this.quotas.values()) {
            while (quota.throttles.size() > 1 && time >= quota.throttles.getFirst().getFirst()) {
                quota.throttles.removeFirst();
            }
        }
    }

    @Override
    public Long getMaterialAvailableTime(Material mat, double qty) {
        ForwardQuota quota = this.quotas.get(mat);
        if (Comparators.compare(quota.getQuota(), qty, 1.0E-7) >= 0) {
            return this.lastTime;
        }
        Tuple<Long, Double> boundingThrottle = null;
        boolean searchSuccessful = false;
        double delta = quota.delta;
        for (Tuple<Long, Double> throttle : quota.throttles) {
            double available = delta + throttle.getSecond();
            if (Comparators.compare(available, qty, 1.0E-7) >= 0) {
                searchSuccessful = true;
                break;
            }
            boundingThrottle = throttle;
        }
        return searchSuccessful ? (Long)boundingThrottle.getFirst() : null;
    }

    @Override
    protected Map<Material, ? extends MaterialQuotas.MaterialQuota> getQuotas() {
        return this.quotas;
    }

    private static class ForwardQuota
    implements MaterialQuotas.MaterialQuota {
        public Deque<Tuple<Long, Double>> throttles;
        public double delta;

        private ForwardQuota() {
        }

        @Override
        public double getQuota() {
            return this.throttles.getFirst().getSecond() + this.delta;
        }
    }
}

